--========================================================--
-- Unseasonal Weather - Radio Forecast State (Shared)
-- Simple ModData wrapper for pending broadcasts.
--========================================================--

if not UW_RF then UW_RF = {} end

UW_RF.MD_KEY = "UW_RF_PENDING"

function UW_RF_GetState()
    local md = ModData.getOrCreate(UW_RF.MD_KEY)
    md.pending = md.pending or nil
    md.lastScheduledDay = md.lastScheduledDay or nil
    return md
end

function UW_RF_SaveState()
    ModData.transmit(UW_RF.MD_KEY)
end

function UW_RF_ClearPending()
    local md = UW_RF_GetState()
    md.pending = nil
    UW_RF_SaveState()
end
